unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, Forms, Dialogs, StdCtrls, Grids, ExtCtrls, Buttons, Menus;

type
  TForm1 = class(TForm)
    Button1: TButton;
    CbBoxTClass: TComboBox;
    Panel1: TPanel;
    ListBox1: TListBox;
    Label1: TLabel;
    Label4: TLabel;
    Label8: TLabel;
    Label2: TLabel;
    ListBox2: TListBox;
    Label3: TLabel;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
{$R *.dfm}

//     
type TMetaClass = class of TObject;



// RqMetaClass    
procedure SimpleClassInfo (RqMetaClass : TMetaClass;
                            RqReport    : TListBox);
begin

   RqReport.Clear;
   RqReport.Items.Add('   : '
                     + RqMetaClass.ClassName);
   RqReport.Items.Add('     : '
                     + IntToStr(RqMetaClass.InstanceSize));
   if RqMetaClass.InheritsFrom(TComponent)
   then RqReport.Items.Add('  ')
   else RqReport.Items.Add('   ');
   RqReport.Items.Add('   : '
                     + RqMetaClass.ClassParent.ClassName);

end;

// RqMetaClass    
procedure SimpleParentInfo (RqMetaClass : TMetaClass;
                            RqReport    : TListBox);
var wMetaClass : TMetaClass;
begin
   RqReport.Clear;
   wMetaClass := RqMetaClass;
   repeat
     wMetaClass := wMetaClass.ClassParent;
     RqReport.Items.Add(wMetaClass.ClassName);
   until (wMetaClass = TObject);
end;

//  
procedure TForm1.Button1Click(Sender: TObject);
var RqMetaClass : TMetaClass;  //   
begin
   RqMetaClass := TStringList;
   case CbBoxTClass.ItemIndex of
     0  : RqMetaClass := TStringList;
     1  : RqMetaClass := TButton;
     2  : RqMetaClass := TBitBtn;
     3  : RqMetaClass := TEdit;
     4  : RqMetaClass := TPopupMenu;
     5  : RqMetaClass := TRadioButton;
     6  : RqMetaClass := TRadioGroup;
     7  : RqMetaClass := TPanel;
     8  : RqMetaClass := TImage;
     9  : RqMetaClass := TForm;
     10 : RqMetaClass := TComboBox;
     11 : RqMetaClass := TGroupBox;
     12 : RqMetaClass := TSpeedButton;
     13 : RqMetaClass := TLabel;
     14 : RqMetaClass := TListBox;
     15 : RqMetaClass := TMainMenu;
     16 : RqMetaClass := TMemo;
     17  : RqMetaClass := TCheckBox;

   end;
   SimpleClassInfo(RqMetaClass, ListBox1);
   SimpleParentInfo (RqMetaClass, ListBox2);
end;




end.
